/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.uddi.VWConfigUDDIRegistryListTableModel;
import filenet.vw.toolkit.admin.property.uddi.VWUDDIBusinessEditDialog;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.api.uddi.WSUDDIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.apache.juddi.error.RegistryException;

public class VWConfigUDDIRegistryListPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWUDDIPanelOperation {
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private Frame m_parentFrame = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_UDDIRegistriesTable = null;
    private VWConfigUDDIRegistryListTableModel m_tableModel = null;
    private boolean m_bModified = false;

    public VWConfigUDDIRegistryListPanel(Frame parentFrame, VWUDDIRegistryList uddiRegistryList) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_uddiRegistryList = uddiRegistryList;
            this.createControls();
            this.m_UDDIRegistriesTable.clearSelection();
            if (this.m_UDDIRegistriesTable.getRowCount() > 0) {
                this.m_UDDIRegistriesTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 131072));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_tableModel.hasChanged();
    }

    public void stopEditing() {
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.stopEditing();
        }
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (this.hasChanged() && (bSuccess = this.m_tableModel.verifyUDDIRegistries())) {
                VWUDDIRegistry[] uddiRegistries = this.m_tableModel.getUDDIRegistries();
                this.m_uddiRegistryList.setUDDIRegistries(uddiRegistries);
                this.m_uddiRegistryList.updateAttribute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public boolean validateData() {
        boolean bSuccess = true;
        if (this.m_tableModel.hasChanged()) {
            bSuccess = this.m_tableModel.verifyUDDIRegistries();
        }
        return bSuccess;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_UDDIRegistriesTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_UDDIRegistriesTable.getSelectedRow()) {
                    this.m_UDDIRegistriesTable.clearSelection();
                }
                this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int selectedRow = this.m_UDDIRegistriesTable.getSelectedRow();
            if (selectedRow < 0) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x100000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 131072));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x100000));
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 131072));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_UDDIRegistriesTable.setRowSelectionInterval(nRow, nRow);
                    this.m_UDDIRegistriesTable.setColumnSelectionInterval(0, 0);
                    this.m_UDDIRegistriesTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                    break;
                }
                case 131072: {
                    this.onAdvancedOption();
                    break;
                }
                case 0x100000: {
                    this.onValidateRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createUDDIRegistriesPanel();
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_uddiRegistryList != null) {
            this.m_uddiRegistryList.releaseResources();
            this.m_uddiRegistryList = null;
        }
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_UDDIRegistriesTable != null) {
            this.m_UDDIRegistriesTable.removeAll();
            this.m_UDDIRegistriesTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    private void createUDDIRegistriesPanel() {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.UDDIRegistryList, 0x10120010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigUDDIRegistryListTableModel(this.m_parentFrame, this.m_uddiRegistryList.getUDDIRegistries());
            this.m_tableModel.addTableModelListener(this);
            this.m_UDDIRegistriesTable = new VWTable(this.m_tableModel);
            this.m_UDDIRegistriesTable.setRowSelectionAllowed(true);
            this.m_UDDIRegistriesTable.getSelectionModel().addListSelectionListener(this);
            this.m_UDDIRegistriesTable.getSelectionModel().setSelectionMode(0);
            this.m_UDDIRegistriesTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_UDDIRegistriesTable, this, VWResource.UDDIRegistryListTable, VWResource.UDDIRegistryListTable);
            this.m_UDDIRegistriesTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_UDDIRegistriesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_UDDIRegistriesTable.getColumn(this.m_tableModel.getColumnName(2));
            aColumn.setMaxWidth(20);
            aColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("publish_16.gif"), VWResource.Publish));
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_UDDIRegistriesTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_UDDIRegistriesTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean canShowAdvancedOption(VWUDDIRegistry vwUDDIRegistry, VWUDDIBusinessEntity vwBusinessEntity) {
        boolean bOK;
        block9: {
            bOK = false;
            String businessKey = vwBusinessEntity.getBusinessKey();
            if (businessKey != null && businessKey.length() > 0) {
                try {
                    WSUDDIRegistry wsUDDIRegistry = new WSUDDIRegistry(vwUDDIRegistry.getName(), vwUDDIRegistry.getInquiryURL(), vwUDDIRegistry.getPublishURL(), vwUDDIRegistry.isPublishable());
                    WSBusinessEntity wsBusinessEntity = wsUDDIRegistry.findBusinessByKey(businessKey.trim());
                    if (wsBusinessEntity != null) {
                        bOK = true;
                        break block9;
                    }
                    String msg = VWResource.InvalidBusinessKeyMsg.toString(businessKey) + "\n\n" + VWResource.ConfirmationDeleteBusinessInfo;
                    int ret = VWMessageDialog.showConfirmDialog(this.m_parentFrame, msg, VWResource.BusinessInformation, 3);
                    if (ret == 1) {
                        vwBusinessEntity.setBusinessKey(null);
                        this.m_bModified = true;
                    }
                    bOK = true;
                }
                catch (RegistryException ex) {
                    String msg;
                    int ret;
                    String errMsg = WSUDDIUtils.getErrMsg(ex);
                    if (!(errMsg != null && errMsg.length() > 0 || (errMsg = ex.getMessage()) != null && errMsg.length() > 0)) {
                        errMsg = ex.toString();
                    }
                    if ((ret = VWMessageDialog.showConfirmDialog(this.m_parentFrame, msg = VWResource.UDDIException.toString(errMsg) + "\n\n" + VWResource.ConfirmationDeleteBusinessInfo, VWResource.BusinessInformation, 3)) == 1) {
                        vwBusinessEntity.setBusinessKey(null);
                        this.m_bModified = true;
                    }
                    bOK = false;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                bOK = true;
            }
        }
        return bOK;
    }

    private boolean validateURLs(VWUDDIRegistry vwRegistry) {
        String urlString = null;
        try {
            urlString = vwRegistry.getInquiryURL();
            URL oURL = new URL(urlString);
            if (oURL == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidUDDIInquiryURL, VWResource.ErrorMessage, 1);
                return false;
            }
            URLConnection aURLCN = oURL.openConnection();
            if (aURLCN == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_failedToConnectInquiryURL, VWResource.ErrorMessage, 1);
                return false;
            }
            urlString = vwRegistry.getPublishURL();
            oURL = new URL(urlString);
            if (oURL == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidUDDIPublishURL, VWResource.ErrorMessage, 1);
                return false;
            }
            aURLCN = oURL.openConnection();
            if (aURLCN == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_failedToConnectPublishURL, VWResource.ErrorMessage, 1);
                return false;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidURL.toString(ex.getLocalizedMessage()), VWResource.ErrorMessage, 1);
            return false;
        }
        return true;
    }

    private void onAdvancedOption() {
        try {
            VWUDDIRegistry vwRegistry;
            this.stopEditing();
            int rowIndex = this.m_UDDIRegistriesTable.getSelectedRow();
            if (rowIndex >= 0 && (vwRegistry = this.m_tableModel.getVWUDDIRegistry(rowIndex)) != null && this.validateURLs(vwRegistry)) {
                VWUDDIBusinessEntity vwBusinessEntity = vwRegistry.getVWBusinessEntity(0);
                if (vwBusinessEntity == null) {
                    vwBusinessEntity = new VWUDDIBusinessEntity();
                    vwRegistry.setVWBusinessEntity(0, vwBusinessEntity);
                }
                if (this.canShowAdvancedOption(vwRegistry, vwBusinessEntity)) {
                    VWUDDIBusinessEditDialog businessInfoDialog = new VWUDDIBusinessEditDialog(this.m_parentFrame, vwRegistry, vwBusinessEntity);
                    businessInfoDialog.setVisible(true);
                    int retStatus = businessInfoDialog.getReturnStatus();
                    if ((retStatus == 1 || retStatus == 4) && businessInfoDialog.hasChanged()) {
                        VWUDDIBusinessEntity retBusinessEntity = businessInfoDialog.getBusinessEntity();
                        this.m_tableModel.setBusinessEntity(rowIndex, retBusinessEntity);
                    }
                    businessInfoDialog.releaseResources();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onValidateRows() {
        boolean bYesToAll = false;
        try {
            this.stopEditing();
            int[] rows = this.m_UDDIRegistriesTable.getSelectedRows();
            for (int nIndex = 0; nIndex < rows.length; ++nIndex) {
                this.m_tableModel.validateRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

